#version 460

uniform samplerCube tex_cm;
uniform float eta;
uniform int mode;

in vec3 n;
in vec3 incident;

out vec4 color;

void main() {

    vec3 nn = normalize(n);
    vec3 i = normalize(incident);

    vec3 refl = reflect(i, nn);
    vec4 c_refl = texture(tex_cm, refl);

    vec3 refr = refract(i, nn, eta);
    vec4 c_refr = texture(tex_cm, refr);

    float dot_IN = dot(i, nn);
    float  R = 1 - eta * eta * (1.0 - dot_IN * dot_IN);

    if (mode == 0)
        color = c_refr;
    else if (mode == 1)
        color = c_refl;
    else if (mode == 2)
        color = mix(c_refl, c_refr, R);
    else 
        color = vec4(R);
}
